﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using IMP.PhosphoRS;

namespace IMP.PhosphoSampleDatasource
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var source = new SampleDatasource();

            source.start();

            if (source.peptideScoreMap == null)
                return;

            double prop;
            string siteProp;
            string sequence;
            flowLayoutPanel1.SuspendLayout();
            flowLayoutPanel1.Controls.Clear();
            foreach (KeyValuePair<int, double> score in source.peptideScoreMap)
            {
                source.propMap.TryGetValue(score.Key,out prop);
                source.sitepropMap.TryGetValue(score.Key,out siteProp);
                source.sequenceStringMap.TryGetValue(score.Key, out sequence);
                var item = new resultItem(score.Key,sequence, prop, score.Value, siteProp);
                item.Width = flowLayoutPanel1.Width - flowLayoutPanel1.Padding.Left - flowLayoutPanel1.Padding.Right - item.Margin.Left - item.Margin.Right;
                flowLayoutPanel1.Controls.Add(item);

            }
            flowLayoutPanel1.ResumeLayout();
        }
    }
}
